/*************************** EX-LIB.CPP ********************* AgF 2001-11-11 *
*                                                                            *
* Example showing how to use assembly language combined random number        *
* generator as base for the non-uniform random variate generator library.    *
* The generator TRandomMotRot is a combination of two random number          *
* generators: RANROT-W and Mother-of-all. This combines high speed with      *
* excellent randomness. Use this for the most demanding applications.        *
*                                                                            *
* Compile for console mode. Must include randomao.lib or randomam.lib or     *
* or randomae.s (form randoma.zip) in project.                               *
*****************************************************************************/

#include <time.h>                      // define time()
#include "randoma.h"                   // define external library
#include "randomc.h"                   // define class TRandomMotRot
// define which random number generator to base random library on:
#define RANDOM_GENERATOR TRandomMotRot
#include "stocc.h"                     // define random library classes
#include "ranmoro.cpp"                 // members of class TRandomMotRot
#include "stoc1.cpp"                   // random library source code
#include "userintf.cpp"                // define system specific user interface


int main() {
  int32 seed = time(0);                // random seed
  StochasticLib1 sto(seed);            // make instance of random library
  int i;                               // loop counter
  double r;                            // random number
  int ir;                              // random integer number

  // make random numbers with uniform distribution
  printf("Random numbers with uniform distribution:\n");
  for (i=0; i<16; i++) {
    ir = sto.IRandom(0, 20);
    printf("%8i  ", ir);}

  // make random numbers with normal distribution
  printf("\n\nRandom numbers with normal distribution:\n");
  for (i=0; i<16; i++) {
    r = sto.Normal(10, 4);
    printf("%8.5f  ", r);}

  // make random numbers with poisson distribution
  printf("\n\nRandom numbers with poisson distribution:\n");
  for (i=0; i<16; i++) {
    ir = sto.Poisson(10);
    printf("%8i  ", ir);}
  
  // make random numbers with binomial distribution
  printf("\n\nRandom numbers with binomial distribution:\n");
  for (i=0; i<16; i++) {
    ir = sto.Binomial(40, 0.25);
    printf("%8i  ", ir);}
  
  // make random numbers with hypergeometric distribution
  printf("\n\nRandom numbers with hypergeometric distribution:\n");
  for (i=0; i<16; i++) {
    ir = sto.Hypergeometric(20, 20, 40);
    printf("%8i  ", ir);}

  
  EndOfProgram();                      // system-specific exit code
  return 0;}
