;          LOG1MX.ASM                                          Agner Fog 2004

;  2003 GNU General Public License www.gnu.org/copyleft/gpl.html

.686
.model flat

PublicAlias MACRO MangledName ; macro for giving a function alias public names
        MangledName label near
        public MangledName
ENDM

.code

; ********** log1mx function **********
; C++ prototype:
; extern "C" double log1mx(double x, double x1);

; calculate log(1-x) without loss of precision when x is small or close to 1
; parameter x1 must be = 1-x

log1mx PROC NEAR
PUBLIC log1mx                          ; mangled names are not needed if extern "C" declaration
PublicAlias _log1mx                    ; extern "C" name

X       equ     [esp+4]
X1      equ     [esp+12]

		fldln2                         ; log(2)
		mov     eax, dword ptr X+4     ; high dword of x
		add     eax, eax               ; shift out sign bit
		cmp     eax, 3FD20000H * 2     ; ~= 1-sqrt(2)/2
		ja      X_BIG
		; |x| < 1-sqrt(2)/2, use fyl2xp1 instruction for best accuracy
        fld     qword ptr X
		fchs
		fyl2xp1
        ret

X_BIG:  fld     qword ptr X1
        fyl2x
		ret

log1mx  ENDP

END
