;          LOG1POW.ASM                                          Agner Fog 2004

;  2003 GNU General Public License www.gnu.org/copyleft/gpl.html

.686
.model flat

PublicAlias MACRO MangledName ; macro for giving a function alias public names
        MangledName label near
        public MangledName
ENDM

.code

extrn pow2_1:near, log1mx:near

; ********** log1pow function **********
; C++ prototype:
; extern "C" double log1pow(double q, double x);

; calculate ln((1-e^q)^x)
; with special care to avoid loss of precision when x is near 0 or large negative.

log1pow PROC NEAR
PUBLIC log1pow                         ; mangled names are not needed if extern "C" declaration
PublicAlias _log1pow                   ; extern "C" name

Q       equ     qword ptr [esp+4]
X       equ     qword ptr [esp+12]

	fldl2e                         ; log2(e)
	fmul    Q

SMAP    STRUC                          ; stack map
qq      dq      ?                      ; q*log2(e)
y0      dd		?					   ; address of eq
eq0     dq      ?                      ; e^q
eq1     dq      ?                      ; 1-e^q
SMAP    ENDS

        sub     esp, type SMAP         ; make space for local data
	fstp    [esp].SMAP.qq          ; store qq
	lea     eax,[esp].SMAP.eq0
	mov     [esp].SMAP.y0, eax     ; store address of eq0
	call    pow2_1                 ; call pow2_1 with qq and y0 as parameters
	; now st(0) = 1-e^q, eq0 = e^q
	fstp    [esp].SMAP.eq1         ; store 1-e^q
	add     esp, 12                ; remove qq and y0 from stack
	call    log1mx                 ; call log1mx with eq0 and eq1 as parameters
	; now st(0) = log(1-e^q)
	add     esp, 16                ; clear stack
	fmul    X	               ; x * log(1-e^q)
	ret
log1pow ENDP

END
