; ----------------------------- MOTHER.ASM -----------------------------
; Mother-of-All random number generator by Agner Fog 1998
; 32-bit mode version for 80x86 and compatible microprocessors
;
; MRandom returns a floating point number between 0 and 1.
; MRandomInit must be called before the first call to MRandom.
;
; C++ prototypes:
; extern "C" void MRandomInit (int seed);
; extern "C" double MRandom (void);
; extern "C" int MIRandom (int min, int max);
;
;  1998, 2004 Agner Fog. 
; GNU General Public License www.gnu.org/copyleft/gpl.html
; ----------------------------------------------------------------------

; The MRandom function is optimized for the Pentium microprocessor.

.386
.model flat

.DATA   ; data segment
M0      DD      0               ; history buffer
M1      DD      0
M2      DD      0
M3      DD      0
MC      DD      0
MF3     DD      2111111111      ; factors
MF2     DD      1492
MF1     DD      1776
MF0     DD      5115
TEMP    DQ      0               ; used for conversion to float

PublicAlias MACRO MangledName ; macro for giving a function alias public names
        MangledName label near
        public MangledName
ENDM

.CODE    ; code segment

MBRandom PROC NEAR
public MBRandom                ; mangled names are not needed if extern "C" declatation
PublicAlias _MBRandom          ; extern "C" name
PublicAlias ?MBRandom@@YAIXZ   ; MS mangled name
PublicAlias @MBRandom$qv       ; Borland mangled name
PublicAlias _MBRandom__Fv      ; Gnu mangled name (Windows)
PublicAlias MBRandom__Fv       ; Gnu mangled name (UNIX)
PublicAlias _Z8MBRandomv       ; Gnu mangled name (UNIX)

        PUSH    EDI
        MOV     EAX, [MF3]
        MUL     [M3]             ; X[n-4]
        MOV     ECX,EAX
        MOV     EAX, [M2]        ; X[n-3]
        MOV     EDI,EDX
        MOV     [M3],EAX
        MUL     [MF2]
        ADD     ECX,EAX
        MOV     EAX, [M1]        ; X[n-2]
        ADC     EDI,EDX
        MOV     [M2],EAX
        MUL     [MF1]
        ADD     ECX,EAX
        MOV     EAX,[M0]         ; X[n-1]
        ADC     EDI,EDX
        MOV     [M1],EAX
        MUL     [MF0]
        ADD     EAX,ECX
        ADC     EDX,EDI
        ADD     EAX,[MC]
        ADC     EDX,0
        MOV     [M0],EAX
        MOV     [MC],EDX
        POP     EDI
        RET
MBrandom ENDP

        
MRandom PROC NEAR
public MRandom
PublicAlias _MRandom          ; extern "C" name
PublicAlias ?MRandom@@YANXZ   ; MS mangled name
PublicAlias @MRandom$qv       ; Borland mangled name
PublicAlias _MRandom__Fv      ; Gnu mangled name (Windows)
PublicAlias MRandom__Fv       ; Gnu mangled name (UNIX)
PublicAlias _Z7MRandomv       ; Gnu mangled name (UNIX)

        CALL    MBRandom             ; random bits
        MOV     EDX, EAX             ; fast conversion to float
        SHR     EAX, 12
        OR      EAX, 3FF00000H
        SHL     EDX, 20
        MOV     DWORD PTR [TEMP+4], EAX
        MOV     DWORD PTR [TEMP], EDX
        FLD1
        FLD     QWORD PTR [TEMP]     ; partial memory stall here
        FSUBR
        RET
Mrandom ENDP


MIRandom PROC   NEAR                 ; make random integer in desired interval
public MIRandom
PublicAlias _MIRandom           ; extern "C" name
PublicAlias ?MIRandom@@YAHHH@Z  ; MS mangled name
PublicAlias @MIRandom$qii       ; Borland mangled name
PublicAlias _MIRandom__Fii      ; Gnu mangled name (Windows)
PublicAlias MIRandom__Fii       ; Gnu mangled name (UNIX)
PublicAlias _Z8MIRandomii       ; Gnu mangled name (UNIX)

        CALL    MBRandom             ; make random number
        MOV     EDX, [ESP+8]         ; max
        MOV     ECX, [ESP+4]         ; min
        SUB     EDX, ECX
        JS      SHORT RERROR         ; max < min
        INC     EDX                  ; max - min + 1
        MUL     EDX                  ; multiply random number by interval and truncate
        LEA     EAX, [EDX+ECX]       ; add min
        RET                          ; RET 8 if not _cdecl calling

RERROR: MOV     EAX, 80000000H       ; error exit   
        RET                          ; RET 8 if not _cdecl calling
MIRandom ENDP


MRandomInit PROC NEAR
public MRandomInit
PublicAlias _MRandomInit          ; extern "C" name
PublicAlias ?MRandomInit@@YAXH@Z  ; MS mangled name
PublicAlias @MRandomInit$qi       ; Borland mangled name
PublicAlias _MRandomInit__Fi      ; Gnu mangled name (Windows)
PublicAlias MRandomInit__Fi       ; Gnu mangled name (UNIX)
PublicAlias _Z11MRandomIniti       ; Gnu mangled name (UNIX)

        MOV     EAX, [ESP+4]    ; seed
        XOR     ECX, ECX
        ; make random numbers and put them into buffer
R80:    IMUL    EAX, 29943829
        DEC     EAX
        MOV     [M0][ECX*4], EAX
        INC     ECX
        CMP     ECX, 5
        JB      R80
        PUSH    EDI
        MOV     EDI, 19
R90:    CALL    MRandom
        FSTP    ST(0)
        DEC     EDI
        JNZ     R90
        POP     EDI
        RET     0                  ; RET 4 if not _cdecl calling
MRandomInit ENDP

        END


; Example of calling from C++ program:

; #include "arandom.h"
; int i;
; MRandomInit (time(0));
; for (i=0; i<100; i++) {
;   printf ("\n%14.10f", MRandom());}
