;          POW21.ASM                                          Agner Fog 2004

;  2003 GNU General Public License www.gnu.org/copyleft/gpl.html

.686
.model flat

extrn instrset:dword, InstructionSet:near

PublicAlias MACRO MangledName ; macro for giving a function alias public names
        MangledName label near
        public MangledName
ENDM

.code

; ********** pow2_1 function **********
; C++ prototype:
; extern "C" double pow2_1(double q, double * y0);

; calculate 2^q and (1-2^q) without loss of precision.
; return value is (1-2^q). 2^q is returned in *y0


pow2_1 PROC NEAR
PUBLIC pow2_1                     ; mangled names are not needed if extern "C" declaration
PublicAlias _pow2_1               ; extern "C" name
        fld     qword ptr [esp+4]             ; q
        mov     ecx, [esp+12]                 ; y0 pointer
        fist    dword ptr [esp+4]             ; round(q)
        sub     esp, 12                       ; make space for 2^round(q)
        mov     dword ptr [esp], 0
        mov     dword ptr [esp+4], 80000000H
        fisub   dword ptr [esp+16]            ; q - round(q)
        mov     eax, [esp+16]                 ; round(q)
        test    eax, eax
        jz      NEAR_ZERO                     ; round(q) = 0, avoid loss of precision
        add     eax, 3FFFH                    ; compute exponent
        mov     [esp+8], eax                  ; tbyte ptr [esp] = 2^round(q)
        jle     short UNDERFLOW               ; underflow
        cmp     eax, 8000H
        jge     short OVERFLOW                ; overflow
        f2xm1                                 ; 2^(q-round(q))-1
        fld1                                  ; 1
        fadd    st(1),st(0)                   ; 2^(q-round(q))
        fxch                                  ; save the 1 for later use
        fld     tbyte ptr [esp]               ; 2^round(q)
        add     esp,12
        fmul                                  ; 2^q
        fst     qword ptr [ecx]               ; store 2^q in y0
        fsub                                  ; 1 - 2^q
        ret
        
NEAR_ZERO:  ; q is near 0, avoid loss of precision
        f2xm1                                 ; 2^q - 1
        add     esp,12
        fld     st                            ; duplicate value
        fxch
        fld1                                  ; 1
        fadd                                  ; 2^q
        fstp    qword ptr [ecx]               ; store 2^q in y0
        fchs                                  ; 1 - 2^q
        ret
        
UNDERFLOW:
        fstp    st
        fldz                                  ; 2^q = 0
        add     esp,12
        fstp    qword ptr [ecx]               ; store 0 in y0
        fld1                                  ; return 1
        ret
        
OVERFLOW:
        push    07F800000H                    ; +infinity
        fstp    st
        fld     dword ptr [esp]               ; load infinity
        add     esp,16
        fst     qword ptr [ecx]               ; store infinity in y0
        fchs                                  ; return -infinity
        ret

pow2_1 ENDP

END
