/*************************** RANLIB.CPP *********************  AF 2004-04-03 *
*                                                                            *
* This example shows how to call the random number generator library         *
* from C++                                                                   *
*                                                                            *
* Compile for console mode. You have to link the appropriate version of the  *
* library into your project. Use randomao.lib for Borland and Symantec       *
* compilers, randomam.lib for most other compilers under Windows, and        *
* randomae.a for Gnu compilers under Linux, BSD and UNIX.                    *
*****************************************************************************/

#include <time.h>                      // define time()
#include <stdio.h>                     // define printf()
#include "randoma.h"                   // define external library
#include "userintf.cpp"                // define system specific user interface


int main () {
  int i;                               // loop counter
  double r;                            // random number
  int ir;                              // random integer number

  int seed = time(0);                  // use time as seed
  TRandomInit(seed);                   // initialize random number generator

  // make random integers in interval from 0 to 99, inclusive:
  printf("\n\nRandom integers in interval from 0 to 99:\n");
  for (i=0; i<40; i++) {
    ir = TIRandom(0,99);
    printf ("%6li  ", ir);}

  // make random floating point numbers in interval from 0 to 1:
  printf("\n\nRandom floating point numbers in interval from 0 to 1:\n");
  for (i=0; i<32; i++) {
    r = TRandom();
    printf ("%8.6f  ", r);}

  // make random bits:
  printf("\n\nRandom bits (hexadecimal):\n");
  for (i=0; i<32; i++) {
    ir = TBRandom();
    printf ("%08lX  ", ir);}

  EndOfProgram();                      // system-specific exit code
  return 0;}

