//                        RANLIB.CS                           AF 2004-04-02
//
// This example shows how to call the random number generator library
// randomad.dll from C#. 
// Remember to add randomad.dll to your project.
// Tested with Microsoft Visual C#.net version 7.1.

using System;
using System.Runtime.InteropServices;


namespace ConsoleApplication1
{
	// Wrap the functions in library randomad.dll into a class:
	public class randomad 	{
		// initialize random number generator:
		[DllImport("randomad.dll", EntryPoint="TRandomInit")]
		public static extern void TRandomInit (int seed);
		// initialize random number generator with multiple seeds:
		[DllImport("randomad.dll", EntryPoint="TRandomInitByArray")]
		public static extern void TRandomInitByArray (
			[MarshalAs(UnmanagedType.LPArray, SizeParamIndex=1)]
			uint[] seeds, int length);
		// get random bits:
		[DllImport("randomad.dll", EntryPoint="TBRandom")]
		public static extern uint TBRandom ();
		// get random integer in interval min <= x <= max:
		[DllImport("randomad.dll", EntryPoint="TIRandom")]
		public static extern int TIRandom (int min, int max);
		// get random double in interval 0 <= x < 1
		// with 32 bits resolution:
		[DllImport("randomad.dll", EntryPoint="TRandom")]
		public static extern double TRandom ();
		// get random double in interval 0 <= x < 1
		// with 52 bits resolution:
		[DllImport("randomad.dll", EntryPoint="TRandom2")]
		public static extern double TRandom2 ();
	}

	
	class Class1
	{
		// The main entry point for the application:
		[STAThread]
		static void Main(string[] args)
		{
			int i, ri;  double rf;
			// initialize random number generator with the time as seed:
			randomad.TRandomInit(Environment.TickCount);

			// make random integers in interval from 0 to 99, inclusive:
			Console.WriteLine("\nRandom integers in interval from 0 to 99:");
			for (i=0; i<40; i++) 
			{
				ri = randomad.TIRandom(0,99);
			        Console.Write(ri.ToString("00    "));
				if (i % 10 == 9) Console.WriteLine("");
			}

			// make random floating point numbers in interval from 0 to 1:
			Console.WriteLine("\n\nRandom floating point numbers in interval from 0 to 1:");
			for (i=0; i<32; i++) 
			{
				rf = randomad.TRandom();
				Console.Write(rf.ToString("0.000000 "));
				if (i % 8 == 7) Console.WriteLine("");
			}

			// make random bits:
			Console.WriteLine("\n\nRandom bits (hexadecimal):");
			for (i=0; i<32; i++) 
			{
				ri = (int)randomad.TBRandom();
				Console.Write(ri.ToString("X8")+" ");
				if (i % 8 == 7) Console.WriteLine("");
			}
		}
	}
}
