{              ranlib.pas                                  Agner Fog 2001-10-23

Pascal unit for linking assembled random number generator library into a
Borland Delphi Pascal project. Since Delphi cannot link to libraries in .lib
format, you have to use one of the object files contained in randomao.zip 
instead.

The .obj files contain assembled code optimized for speed.

This file has been tested with Borland Delphi version 6.0. For other versions
of Pascal and Delphi, you need the appropriate LINK statements to link in the
.obj files and the external function declarations.

Example of use:
-------------------------------------------------------------------------------
uses
  ranlib,
  SysUtils;

var seed, i: integer;
var s: string;

begin

  seed := Round(Time()*3600000.0);

  WRandomInit(seed);

  for i := 1 to 20 do begin
    Writeln(WRandom(), '  ', WIRandom(0,99));
  end;

  Writeln('');
  Read(s);

end.
-------------------------------------------------------------------------------
}

unit ranlib;

interface
{link in external functions:}

{$LINK motrot.obj}
{$LINK ranrot.obj}
{$LINK mersenna.obj}
{$LINK mothera.obj}

{declare external functions for motrot:}
procedure XRandomInit(seed:Integer); cdecl; external;
function XRandom():Double; cdecl; external;
function XIRandom(min:Integer; max:Integer): Integer; cdecl; external;

{declare external functions for ranrot:}
procedure WRandomInit(seed:Integer); cdecl; external;
function WRandom():Double; cdecl; external;
function WIRandom(min:Integer; max:Integer): Integer; cdecl; external;

{declare external functions for mersenna:}
procedure TRandomInit(seed:Integer); cdecl; external;
function TRandom():Double; cdecl; external;
function TIRandom(min:Integer; max:Integer): Integer; cdecl; external;

{declare external functions for mothera:}
procedure MRandomInit(seed:Integer); cdecl; external;
function MRandom():Double; cdecl; external;

implementation

end.
