'                 RANLIB.VB                                   AF 2004-04-03
'
' Example showing how to call library randomad.dll from Visual Basic.net

Imports System.Runtime.InteropServices

Module Module1

    ' Declare functions imported from library randomad.dll

    ' Initialize random number generator with integer seed:
    Declare Auto Sub TRandomInit Lib "randomad.dll" _
    (ByVal seed As Integer)

    ' Initialize random number generator with multiple seeds:
    Declare Auto Sub TRandomInitByArray Lib "randomad.dll" _
    (<MarshalAs(UnmanagedType.LPArray, SizeParamIndex:=1)> _
    ByVal seeds() As Integer, ByVal length As Integer)

    ' Get 32 random bits:
    Declare Auto Function TBRandom Lib "randomad.dll" _
    () As UInt32

    ' Get random integer in interval min <= x <= max:
    Declare Auto Function TIRandom Lib "randomad.dll" _
    (ByVal min As Integer, ByVal max As Integer) As Integer

    ' Get random double in interval 0 <= x < 1
    ' with a resolution of 32 bits:
    Declare Auto Function TRandom Lib "randomad.dll" _
    () As Double

    ' Get random double in interval 0 <= x < 1
    ' with a resolution of 52 bits:
    Declare Auto Function TRandom2 Lib "randomad.dll" _
    () As Double

    Sub Main()
        Dim i As Integer

        TRandomInit(Environment.TickCount) ' initialize with time as seed

        Console.WriteLine("Random integers in interval from 0 to 99:")
        For i = 1 To 40
            Console.Write(TIRandom(0, 99).ToString("00  "))
            If i Mod 10 = 0 Then
                Console.WriteLine()
            End If
        Next i
        Console.WriteLine()

        Console.WriteLine("Random floating point numbers in interval from 0 to 1:")
        For i = 1 To 32
            Console.Write(TRandom().ToString("0.000000 "))
            If i Mod 8 = 0 Then
                Console.WriteLine()
            End If
        Next i
        Console.WriteLine()

        Console.WriteLine("Random bits (Hexadecimal):")
        For i = 1 To 32
            Console.Write(TBRandom().ToString("X8") + " ")
            If i Mod 8 = 0 Then
                Console.WriteLine()
            End If
        Next i

    End Sub

End Module
