/*
	Copyright 2006 Johannes Kopf (kopf@inf.uni-konstanz.de)

	Implementation of the algorithms described in the paper

	Recursive Wang Tiles for Real-Time Blue Noise
	Johannes Kopf, Daniel Cohen-Or, Oliver Deussen, Dani Lischinski
	In ACM Transactions on Graphics 25, 3 (Proc. SIGGRAPH 2006)

	If you use this software for research purposes, please cite
	the aforementioned paper in any resulting publication.
	
	You can find updated versions and other supplementary materials
	on our homepage:
	http://graphics.uni-konstanz.de/publications/2006/blue_noise
*/

#include <stdio.h>
#include "randoma.h"
#include "../../source/points.h"

int numTiles, numColors, numSubtiles = 4, numSubdivs = 1;
Tile * tiles, * sources;

ubyte colors[] = {152, 203, 0,
                  255, 153, 255,
                  255, 152, 153,
                  204, 255, 102};

// number of points per tile
int numPoints = 64;

void main()
{
	// **************
	// initialization

	// init random number generator
	TRandomInit(0);

	// define Cohen et al. tile set
	numTiles = 8;
	tiles = new Tile[numTiles];
	tiles[0] = Tile(2,1,3,0);
	tiles[1] = Tile(2,0,3,1);
	tiles[2] = Tile(3,0,3,0);
	tiles[3] = Tile(2,0,2,0);
	tiles[4] = Tile(3,0,2,1);
	tiles[5] = Tile(3,1,2,0);
	tiles[6] = Tile(3,1,3,1);
	tiles[7] = Tile(2,1,2,1);
	numColors = 4;
	sources = new Tile[numColors];

	// ****************************************
	// step 1: create progressive wang tile set

	createSourceTiles();
	createWangBodies();
	mergeNorth();
	mergeEast();
	mergeSouth();
	mergeWest();
	fixRanking();

	// ********************************
	// step 2: create subdivision rules

	createSubdivision();

	// ************************************************
	// step 3: make progressive wang tile set recursive

	relaxPoints();
	initFinalRanking();
	createFinalRanking();

	// save tile set
	saveTileSet("tileset.dat");	
}